import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blueberry_bush_stage0', {
        onRandomTick: ({ block }) => {
            const stage = block.permutation.withState("v360:bush", 1)
            block.setPermutation(stage)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blueberry_bush_stage1', {
        onRandomTick: ({ block }) => {
            const stage = block.permutation.withState("v360:bush", 2)
            block.setPermutation(stage)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blueberry_bush_stage2', {
        onRandomTick: ({ block }) => {
            const stage = block.permutation.withState("v360:bush", 3)
            block.setPermutation(stage)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blueberry_bush_interact0', {
        onPlayerInteract({ block, player }) {
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const stage = block.permutation.withState("v360:bush", 1);
            if (selectedItem?.typeId !== 'minecraft:bone_meal') {
                block.setPermutation(stage)
                block.dimension.playSound('block.sweet_berry_bush.pick', block.location)
                block.dimension.runCommand(`loot spawn ${Object.values(block.location).join(' ')} loot blueberry2`)
                block.setPermutation(stage)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blueberry_bush_interact1', {
        onPlayerInteract: ({ block }) => {
            const stage = block.permutation.withState("v360:bush", 1)
            block.setPermutation(stage)
            block.dimension.playSound('block.sweet_berry_bush.pick', block.location)
            block.dimension.runCommand(`loot spawn ${Object.values(block.location).join(' ')} loot blueberry3`)
            block.setPermutation(stage)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blueberry_bush_interact_bonemeal0', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location;
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const stage = block.permutation.withState("v360:bush", 1);
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                block.setPermutation(stage)
                block.dimension.playSound('item.bone_meal.use', block.location)
                player.runCommandAsync('clear @s minecraft:bone_meal 0 1')
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blueberry_bush_interact_bonemeal1', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const stage = block.permutation.withState("v360:bush", 2);
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                block.setPermutation(stage)
                block.dimension.playSound('item.bone_meal.use', block.location)
                player.runCommandAsync('clear @s minecraft:bone_meal 0 1')
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blueberry_bush_interact_bonemeal2', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const stage = block.permutation.withState("v360:bush", 3);
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                block.setPermutation(stage)
                block.dimension.playSound('item.bone_meal.use', block.location)
                player.runCommandAsync('clear @s minecraft:bone_meal 0 1')
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
        }
    })
})